require( "HiddenObject/Script/style.lua" );

kButtonSpacing = 55;
kButtonY = 220;
kButtonX = 47;

function QuitGame()
	CloseWindow();
end

local ButtonTextColor = Color(131, 167, 184, 255);
local FooterButtonTextColor = Color(133, 174, 204, 255);
local MainMenuTextColor = Color(204, 198, 183, 255);

MainMenuButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  32,
  ButtonTextColor
};

MainMenuTimelessFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  28,
  ButtonTextColor
};

DisabledButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  32,
  Color(0, 0, 0, 255),
};

FooterMenuButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  24,
  FooterButtonTextColor
};

MainMenuTextFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  20,
  MainMenuTextColor
};


footerButtonY = 545;

MainMenuGraphics = {
	"HiddenObject/UI/Button/mainmenubuttonnormal",
	"HiddenObject/UI/Button/mainmenubuttondown",
	"HiddenObject/UI/Button/mainmenubuttonover"
};


MainMenuStyle = {
	parent = DefaultStyle,
	font = MainMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = MainMenuGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};



DisabledGraphics = {
	"HiddenObject/UI/Button/mainmenubuttonnormal",
	"HiddenObject/UI/Button/mainmenubuttonnormal",
	"HiddenObject/UI/Button/mainmenubuttonnormal"
};


DisableStyle = {
	parent = DefaultStyle,
	font = DisabledButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = DisabledGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};



HighScoreGraphics = {
	"HiddenObject/UI/Button/highscorenormal",
	"HiddenObject/UI/Button/highscoremousedown",
	"HiddenObject/UI/Button/highscoremouseover"
};

HighScoreStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = HighScoreGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};



ChangeUserGraphics = {
	"HiddenObject/UI/Button/changeusernormal",
	"HiddenObject/UI/Button/changeusermousedown",
	"HiddenObject/UI/Button/changeusermouseover"
};

ChangeUserStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ChangeUserGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


CreditsGraphics = {
	"HiddenObject/UI/Button/creditsnormal",
	"HiddenObject/UI/Button/creditsmousedown",
	"HiddenObject/UI/Button/creditsmouseover"
};

CreditsStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = CreditsGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};



FooterMenuGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover"
};


FooterMenuStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterMenuGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


function UpdateLoadButton()

	if IsNewUser() then 
		EnableWindow("loadgame", false);
		EnableWindow("loadgame_disabled", true);
	else 
		EnableWindow("loadgame_disabled", false);
		EnableWindow("loadgame", true);
	end

end



function CreateFirstUser()
	name = DoModal("HiddenObject/Script/mustentername.lua");
	CreateNewUser(name);
end

MakeDialog
{
	--CheckUsers();
	-- Name the modal dialog
	name="mainmenu",
	MainMenu
	{
		fit=true;
		Bitmap
		{
			name="backgroundimage",
			image="HiddenObject/UI/Background/MainMenu/mainmenubackground", 
			
					
			Bitmap
			{
				name="layer0",
				image="HiddenObject/UI/Background/MainMenu/bolt1", 
				x = 263,
				y = 123,
			},
			
						
			Bitmap
			{
				name="layer1",
				image="HiddenObject/UI/Background/MainMenu/bolt2", 
				x = 235,
				y = 58, 
			},
			
			
						
			Bitmap
			{
				name="layer2",
				image="HiddenObject/UI/Background/MainMenu/bolt3", 
				x = 596, 
				y = 0,
			},
			
			
						
			Bitmap
			{
				name="layer3",
				image="HiddenObject/UI/Background/MainMenu/bolt4", 
				x = 238,
				y = 0,
			},
			
			Bitmap
			{
				name="layer4",
				image="HiddenObject/UI/Background/MainMenu/buildings", 
				x = 0,
				y = 0,
			},
			
			Bitmap
			{
				name="layer5",
				image="HiddenObject/UI/Background/nocturnallogo", 
				x = 0,
				y = 0,
			},		
			SetStyle( MainMenuStyle ),
			
			Button
			{
				x=kButtonX,
				y=kButtonY,
				name="newgame",
				label = "newgame",
				--MenuButtonLabel("newgame"),
				type = kPush,
				font = MainMenuButtonFont,
				command=
					function()
						if IsNewUser() then SendGameMessage("resetlevel");
						else
							result = DisplayDialog { 
								"HiddenObject/script/yesno.lua", 
								body ="newgamewarning",
								title = "new_game" 
							};
							if (result=='yes') then
								SendGameMessage("resetlevel");
							end											
						end
					end
			},
			Button
			{
				x=kButtonX,
				y=kButtonY + (kButtonSpacing * 1),
				name="loadgame",
				label= "loadgame",
				type = kPush,
				command=
					function()
						SendGameMessage("loadLevel");
					end
			},
			SetStyle( DisableStyle  ),
			Button
			{
				x=kButtonX,
				y=kButtonY + (kButtonSpacing * 1),
				name="loadgame_disabled",
				label= "loadgame",
				type = kPush,
				command=
					function()
					end
			},

			SetStyle( MainMenuStyle ),
			Button
			{
				x=kButtonX,
				y=kButtonY + (kButtonSpacing * 2),
				name="options",
				label = "options",
				type = kPush,
				command=
					function()
						DoModal("HiddenObject/Script/options.lua");
					end
			},

			Button
			{
				x=kButtonX,
				y=kButtonY + (kButtonSpacing *3),
				name="help",
				label = "help",
				type = kPush,
				command=
					function()
						DoModal("HiddenObject/Script/help.lua");
					end
			},


			Button
			{
				x=kButtonX,
				y=kButtonY + (kButtonSpacing *4),
				name="quit",
				label = "quit",
				type = kPush,
				command=
					function()
						DoModal("HiddenObject/Script/quitverify.lua");
					end
			},
			
			SetStyle( HighScoreStyle ),
			Button
			{
				x=491,
				y=footerButtonY,
				name="highscores",	
				label = "highscores",
				type = kPush,
				command=
					function()
						SendGameMessage("saveTimeMode");
						SwapToModal("HiddenObject/Script/hiscore.lua");
					end
			},
			
			SetStyle(CreditsStyle),
			Button
			{
				x=622,
				y=footerButtonY,
				name="credits",
				label = "credits",
				type = kPush,
				command=
					function()
						SendGameMessage("saveTimeMode");
						DoModal("HiddenObject/Script/credits.lua");
					end
			},
			
			
			SetStyle(ChangeUserStyle),
			Button
			{
				x=364,
				y=footerButtonY,
				name="changeplayer",
				label="changeplayer",
				type = kPush,
				command=
					function()
						SendGameMessage("saveTimeMode");
						DoModal("HiddenObject/Script/chooseplayer.lua");
						UpdateLoadButton();
					end
			},
			
			Text
			{
				font = MainMenuTextFont,
				name = "welcome",
				x=155,y=550,w=kMax,h=30,
				flags = kHAlignLeft + kVAlignCenter,
				label = "entername"
			},
			
			Text
			{
				font = MainMenuTextFont,
				name = "player",
				x=80,y=550,w=kMax,h=30,
				flags = kHAlignLeft + kVAlignCenter,
				label = "player"
			},
			
			SetStyle(CheckboxButtonStyle),			
			Button
			{
				name="timelessmodebutton",
				x=217,
				y=kButtonY - kButtonSpacing * 1.1 ,
				w=42,
				h=42,		
				command = function() SendGameMessage('timeless'); end		
			};
			Text
			{
				font = MainMenuTimelessFont,
				name = "timelessmode",
				x= 55,
				y=kButtonY - kButtonSpacing * 0.95 ,
				w=kMax,
				h=32,
				flags = kHAlignLeft + kVAlignTop,
				label="timelessmode",
			};
		},
	}
}

EnableWindow("layer0", false);
EnableWindow("layer1", false);
EnableWindow("layer2", false);
EnableWindow("layer3", false);

UpdateLoadButton();